pico-8 cartridge // http://www.pico-8.com
version 41
__lua__

local orderlist={}
local samples={}
local patlen={}

--#include patterns.p8
#include rk_play.p8
#include msx_play.p8

#include px9dec.p8

-- shared
#include math.p8
#include mem.p8
--#include rocket.p8
#include matrix.p8
#include polyfiller_xyzuv.p8
#include tunnel.p8
#include render.p8

-- parts
#include walkanim.p8
#include eyetunnel.p8
#include room.p8
#include interference.p8
#include neuroblend.p8


local prev= -1
local part= -1
local params= {}

local active= nil

image = {
  colors1= { [0]= 0x00,0x80,0x81,0x01,0x82,0x8d,0x89,0x88,0x84,0x09,0x08,0x85,0x0f,0x87,0x07,0x0 },
  colors2= { [0]= 0x00,0x80,0x82,0x00,0x05,0x83,0x02,0x0c,0x04,0x0f,0x8d,0x82,0x86,0x08,0x07,0x08 },
  scroll=0,
  flash=0,
  pic=0,
  images = {}
}

image.setparams= function(this, p)
end

image.load = function(this)
  reload(0x8000, 0x0, 0x4300, "data_4.p8")
 
	px9_decomp(0,0, 0xa000, sget, sset) -- firebird
  this.images[1]= storemem(0, 0x2000)

	px9_decomp(0,0, 0x9000, sget, sset)
  memcpy(0x2000, 0x0, 0x2000)
	px9_decomp(0,0, 0x8000, sget, sset)
  this.images[2]= storemem(0, 0x4000)
end

image.init = function(this)
  this.flash=16.0
  this.scroll=0
  this.pic+=1
  if (this.pic==1) then
    restoremem(0x8000, this.images[1])
  else
    restoremem(0x8000, this.images[2])
    memset(0xc000, 0x0, 0x4000)
  end
end

image.update = function(this)
  this.flash-=0.5
      if (this.flash<0) then 
       this.flash=0 
    end
      memset(0x5f70, 0x0, 16)

  if (this.pic==1) then
    pal(this.colors1, 1)
  else
      this.scroll+=0.5
    pal(this.colors2, 1)	
  end
end

image.draw = function(this)
  memcpy(0x6000, 0x8000+(this.scroll&-1)*64, 0x2000)
  if (this.pic==1) then
  fillp( (dithertab[this.flash&-1]&-1)|0x0.8 )
  color(14)
  rectfill(0,0,128,128,0)
  end
end    

local partlist={
    [0]= walkanim,
         eyetunnel,
         room,
         interference,
         neuroblend,
         image,

        nil
  }

function showpal()
    for i=0,15 do
      color(i)
      rectfill(i*8,125,i*8+8,128)
    end
end

function copy4(addr, len)
  local t={}
  for i=0,len-1 do
    t[i]= peek4( addr+i*4 )
  end
  return t
end

function msx_init()
  for i=0,3 do
    msx_channels[i]= { pos= 0, vol= 1.0, incr= 0.0, smp= nil, nr= i }
  end

  reload(0x8000, 0x0, 0x4300, "pat_all.p8")
  unpackmem2(0x8040, patlen)
  for p=0,31 do 
      memset(0x0, 0x0, 0x2000)
      px9_decomp(0,0, peek2(0x8000+p*2), sget, sset) 
      msx_patterns[p]= copy4(0x0, 256)
  end

  reload(0x8000, 0x0, 0x4300, "msx_data1.p8")
  local start= 0x0
  start= unpackmem(0x8000, orderlist)
  
  start+=2
  for i=1,19 do
    local smp= {}
    for j=1,4 do 
      smp[j]= peek2(start)
      start+=2
    end
--    print(smp[1].." "..smp[2].." "..smp[3].." "..smp[4])
    samples[i]= smp
  end  


-- orderlist
-- samples
local cartnum= 1
for i=1,19 do
  local smp= samples[i]
  local size= smp[1]
--  print("loading "..i..": "..size)
  local data={}
  local offset= 0
  if (size) then
    size+=2
    while (size>0) do
      local rest= 0xc300 - start
      if (rest==0) then
         cartnum+=1
--         print("loading cart "..cartnum)
         reload(0x8000, 0x0, 0x4300, "msx_data"..cartnum..".p8")
         rest= 0x4300
         start= 0x8000
      end
      local len= min(rest, size)
      for j=0,len do   -- hier nur so viel kopieren wie wirklich da ist
        local v1= peek(start+j)-128
        data[offset+j]= v1
      end
      offset+=len
      size-=len
      start+=len
    end
    smp[5]= data
  end
end


end


function _init() 
    cls()
    print("       titanics decruncher")
    print("     decrunches while loading")

local msxdata= storemem(0x3100, 0x1200)
rk_init()
--    for i=0,15 do pal(i,0,1) end
    for i=0,#partlist do
--      print("loading part "..i)
      partlist[i]:load()
    end
    restoremem(0x3100, msxdata)
    msx_init()
end

local fresh= false
local row= 0
function _update()
    row= 0
    local ord= stat(54)
    if (ord>=0) then
--       print(ord)
       row= (patlen[ ord ] + stat(56))/6
    end
    part,params= rk_update(row)
--    print("row: "..row.." part: "..part)
    
--    if (#params > 0) then
      if (part != prev) then
        prev= part
        active= partlist[part]
        if (active) then active:init() fresh= true end
      end

--    end
  if (active) then
     active:setparams(params)
     active:update()
  end
end

function _draw()
  if (msx_flack == 0) then
    music(-1)
    update_mixer(256*3)
  end

  local total= stat(109)*3
  local avail= stat(108)

  -- custom mixer output size
  -- previously always 256-sample-blocks were send 
  -- which caused in a 0-sample-block every 4 frames)
  while (total+184 >= avail) do
     update_mixer(184)
     total= stat(109)*3
     avail= stat(108)
  end
  
  if (msx_flack == 0) then
	  music(0)
	  msx_flack = 1		
  end

    cls()

    if (active and not fresh) active:draw()
    fresh= false

    pal({[0]=0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},0)
    color(13)
--    if (#params>0 and part>=0) then
--        print(row..": "..part..": "..params[1].." "..params[2].." "..params[3].." "..params[4].." "..params[5])
--    end
  
--    print(stat(1))
--    print(part)
--    showpal()
end

__sfx__
000200003f650140503c640140403963014030366201302031610120102c61010010216100c010116103a600226003a60021600016003e6003e6003f6003f60003600026003f6003f6003f6003f6003f6003f600
00010912396500c3500c350050500405002050010500112001150010100111001010011100101001110010100111001010011000600008000090000c0000d0000d0000d0000d0000d0000d0000d0000d0000d000
000100003f65033730366201b71001600016000160001600016000160001600016000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000118200c050000500c050000500c150000500c150000500c150001500c150001500c250001500c250001500c250002500c250002500c350002500c350002500c350003500c350003500c350003500c35000350
000802040c350002500c2100011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010800120025000350001500075000150007500015000750001500075000150007500015000750001500075000150007500015000750001500075000150007500015000750001500075000150007500025000350
010100002337023300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000103002900025000210001d000190001400010000080000c0000000008000090000900001000000000900000000090000900009000090000800000000070000500000000040000000003000000000000000000
010c00201895013951109510c951188501885018a500da5018a200da20189501895018850188500000018a501895018a10189500c951188501885018a500da5018a200da20189501895018850188501885018850
010c00001aa300ea30109001aa100ea101880018a000da0018a000da00189001890018800188000000018a001890018a00189000c9000ea2019a100ea100da5018a200da201895018a5018850000001885018850
451800001895000951000000000017a0015a0013a000da0013a000da0013a001890000a00188000000018a0002a0000a0002a00000000000000000000000000000000000000000018a200da2018a101ca201da10
010c00001895013951109510c951188501885018a500da5018a200da20189501895018850188500000018a501895018a10189500c951188501885018a500da5018a200da20189501895018855199551885519855
010c00001895013951109510c951188501885018a500da5018a200da20189501895018850188500000018a501895013951109510c9510c9500c9500c9500c95026b5023b5121b411fb411db311cb311ab2118b21
010c00001895013951109510c951188501885018a500da5018a200da20189501895018850188500000018a501885018a10189500c951188501885018a500da501885019855189501895018850188501895018951
010c00001895013941109310c9253792037c0037c003792019a503791019a1039c00379201980034810118511895013955109550c9553792000000000003792019a503791019a100000037920000000000000000
090c00001a460194601a3601736000000000001a440194401a3401734000000000001a430194301a3301733000000000001a420194201a3201732000000000001a410194101a3101731000000000000000000000
090c0000194601746019360153600000000000194401744019340153400000000000194301743019330153300000000000194201742019320153201a9001a8001941017410193101531000000000000000000000
0118000017e701e4000be701e3000be70000000be701e40017e701e3000be70000000be70000000be700000017e701e4000be701e3000be70000000be701e40017e701e3000be70000000be70000000be7000000
510c00001a440194401a3401734000000000001a430194301a3301733000000000001a420194201a3201732000000000001a410194101a3101731000000000000000000000000000000000000000000000000000
010600001895013951109510c9511895013951109510c9511895013951109510c9510000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010c00001cb501cb501cb501cb2028b5128b500eb510eb510eb500eb500eb5026b500eb510eb500eb500eb5000000000000000000000000000000000000000000000000000000000000000000000000000000000
010c0000189501394110931000000000037c0037c000000000000000000000039c00379201980034810118511895013955109550c9553792000000000003792019a503791019a100000037920000000000000000
010c000000000000000000000000000000000000000000000e000000001a0000e000000001a0000e000000002fb152fb152fb152fb252fb252fb252fb352fb352fb352fb452fb552fb652fb7530b7531b7532b75
0118000015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5021d5021d5021d5021d5015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5015d5021d5021d5021d5021d50
0118000017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5023d5023d5023d5023d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5023d5023d5023d5023d50
0118000013d5013d5013d5013d5013d5013d5013d5013d5013d5013d5013d5013d501fd501fd501fd501fd5013d5013d5013d5013d5013d5013d5013d5013d5013d5013d5013d5013d501fd501fd501fd501fd50
010c00001895013941109310c9253792037c0037c003792019a503791019a1039c00379201980034810118511895013955109550c9553792000000189503792019a50379101897000000379251a855000001a855
0110000017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5017d5000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010c00001895013941109310c9253792037c0037c003792019a503791019a1039c0037920198001a8551185118950000000000000000000000000000000000000000000000000000000000000000000000000000
050618202677025770237701e7702677025770237701e7702676025760237601e7602675025750237501e7502674025740237401e7402673025730237301e7302672025720237201e7202671025710237101e710
050618202577023770217701c7702577023770217701c7702576023760217601c7602575023750217501c7502574023740217401c7402573023730217301c7302572023720217201c7202571023710217101c710
050600082672025720237201e7202671025710237101e71031c0031c0031c0031c002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc003cb003bb0039b0037b0035b0034b0032b0030b00
050600082572023720217201c7202571023710217101c7102fc002fc002fc00000002fc002fc002fc002fc002fc00000002fc002fc002fc002fc002fc00000002fc002fc002fc002fc002fc00000000000000000
010c000018a200da2010951189501885018850189501395118a200da201885018850189501395118a200da201895018a10189500c951188501885018a500da5018a200da20189501895018850188501885018850
050c000023c5023c550000023c5023c550000021c5021c5521c5021c502fc502fc5523c5023c5539c0039c0039c002dc002dc0000000000000000000000000000000000000000000000000000000000000000000
050c000023c5023c550000023c5023c550000021c5021c5021c5021c502fc502fc5523c5023c5539c0039c0023c5023c552dc0000000000000000000000000000000000000000000000000000000000000000000
010c100017d7017d7017d6017d6017d5017d5017d4017d4017d3017d3017d2017d2017d1017d1017d1017d1000000000000000000000000000000000000000000000000000000000000000000000000000000000
010c00002fc002fc002fc0037c0037c0037c002fc002fc002fc0037c0037c0037c002fc002fc002fc0037c002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc002fc00
010c000032c0032c0032c0032c0032c0032c0031c0031c0031c0031c0031c0031c002ac002ac002ac002ac002ac002ac002ac002ac002ac002ac002ac002ac0024b0026b0028b0029b002bb002db002fb0030b00
010c000032c0032c0032c0032c0032c0032c0031c0031c0031c0031c0031c0031c002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc002bc003cb003bb0039b0037b0034c0034c0034c0034c00
0118000017175171001c0751e07500000210752140017075000001c075000001e075210750000017175000001c1751e175000002117500000231750000017175000000000000000300003c610306112461118611
01180000169700a9610a9511c0151e01500000230152140017015000001c015000001e015230150000017115000001c1151e11500000231150000017015000001c015000001e015230150000017115000001a115
0118000000000171151e4001c0151e01500000210152140017015000001c015000001e015210150000017115000001c1151e11500000211150000017015000001c015000001e015210153c610306112461118611
0118000000000171151e4001c0151e01500000210152140017015000001c015000001e015210150000017115000001c1151e11500000211150000017015000001c015000001e015210153c611306112461118611
01180000171751e4001c0751e07500000230752140017075000001c075000001e075230750000017175000001c1751e17500000231750000017075000001c075000001e075230750000017175000001a17500000
01180000171751e4001c0751e07500000210752140017075000001c075000001e075210750000017175000001c1751e17500000211750000017075000001c075000001e075210750000017175000001a17500000
0118000000000171151e4001c0151e01500000230152140017015000001c015000001e015230150000017115000001c1151e11500000231150000017015000001c015000001e015230150000017115000001a115
0118000000000171151e4001c0151e01500000210152140017015000001c015000001e015210150000017115000001c1151e11500000211150000017015000001c015000001e015210150000017115000001a115
0118000017175171001c0751e07500000210752140017075000001c075000001e075210750000017175000001c1751e1750000021175000002317500000171750000000000000000000000000000000000000000
0118000000000171151e4001c0151e01500000210152140017015000001c015000001e015210150000017115000001c1151e11500000211150000023115000001711500000000000000000000000000000000000
010c0000171701716517112171121c0701c0651e0701e0651e0121e01223070230652301223012170701706517012170121c0701c0651c0121c0121e0701e0652307023065230122301217170171651711217112
010c00001c1701c1651e1701e1651e1121e11223170231652311223112170701706517012170121c0701c0651c0121c0121e0701e06523070230652301223012171701716517112171121a1701a1651a1121a112
010c0000171701716517112171121c0701c0651e0701e0651e0121e01221070210652101221012170701706517012170121c0701c0651c0121c0121e0701e0652107021065210122101217170171651711217112
010c00001c1701c1651e1701e1651e1121e11221170211652111221112170701706517012170121c0701c0651c0121c0121e0701e06521070210652101221012171701716517112171121a1701a1651a1121a112
010c00001c1701c1651e1701e1651e1121e1122117021165211122111223170231652311223112171701716517012170121701217012170121701217012170120000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
00 07070707
01 2c2e513c
00 2d2f3c3c
00 2c2e130a
00 2d2b130a
00 2c131d0a
00 28131e0a
00 32464a08
00 33464608
00 34464a08
00 3546460b
00 32561d08
00 33561f08
00 34461e08
00 3616200c
00 2221620e
00 2321630e
00 2221620e
00 2321631a
00 22211d0e
00 23211f0e
00 22211d0e
00 23211f1a
00 4142530e
00 41424a1a
00 4f425c0e
00 4f42561a
00 12425c0e
00 4f425f1a
00 12425c0e
00 4f42161a
00 2c29181d
00 2d2a181e
00 320a191d
00 3542171e
00 3242191d
00 3542171e
00 1d425c15
00 4f425f1a
00 4f425c0e
00 4f42561a
00 12425c15
00 12425f1a
00 12425c0e
00 1242161a
04 6c69241d

